/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.FileUtil;
import net.minecraft.Util;
import net.minecraft.core.UUIDUtil;
import net.minecraft.server.packs.DownloadCacheCleaner;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.HttpUtil;
import net.minecraft.util.eventlog.JsonEventLog;
import net.minecraft.util.thread.ProcessorMailbox;
import org.slf4j.Logger;

public class DownloadQueue
implements AutoCloseable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int MAX_KEPT_PACKS = 20;
    private final Path cacheDir;
    private final JsonEventLog<LogEntry> eventLog;
    private final ProcessorMailbox<Runnable> tasks = ProcessorMailbox.create(Util.nonCriticalIoPool(), "download-queue");

    public DownloadQueue(Path p_314439_) throws IOException {
        this.cacheDir = p_314439_;
        FileUtil.createDirectoriesSafe(p_314439_);
        this.eventLog = JsonEventLog.open(LogEntry.CODEC, p_314439_.resolve("log.json"));
        DownloadCacheCleaner.vacuumCacheDir(p_314439_, 20);
    }

    private BatchResult runDownload(BatchConfig p_314482_, Map<UUID, DownloadRequest> p_314452_) {
        BatchResult $$2 = new BatchResult();
        p_314452_.forEach((p_314645_, p_314573_) -> {
            Path $$4 = this.cacheDir.resolve(p_314645_.toString());
            Path $$5 = null;
            try {
                $$5 = HttpUtil.downloadFile($$4, p_314573_.url, p_314508_.headers, p_314508_.hashFunction, p_314573_.hash, p_314508_.maxSize, p_314508_.proxy, p_314508_.listener);
                p_314638_.downloaded.put((UUID)p_314645_, $$5);
            }
            catch (Exception $$6) {
                LOGGER.error("Failed to download {}", (Object)p_314573_.url, (Object)$$6);
                p_314638_.failed.add((UUID)p_314645_);
            }
            try {
                this.eventLog.write(new LogEntry((UUID)p_314645_, p_314573_.url.toString(), Instant.now(), Optional.ofNullable(p_314573_.hash).map(HashCode::toString), $$5 != null ? this.getFileInfo($$5) : Either.left((Object)"download_failed")));
            }
            catch (Exception $$7) {
                LOGGER.error("Failed to log download of {}", (Object)p_314573_.url, (Object)$$7);
            }
        });
        return $$2;
    }

    private Either<String, FileInfoEntry> getFileInfo(Path p_314601_) {
        try {
            long $$1 = Files.size(p_314601_);
            Path $$2 = this.cacheDir.relativize(p_314601_);
            return Either.right((Object)new FileInfoEntry($$2.toString(), $$1));
        }
        catch (IOException $$3) {
            LOGGER.error("Failed to get file size of {}", (Object)p_314601_, (Object)$$3);
            return Either.left((Object)"no_access");
        }
    }

    public CompletableFuture<BatchResult> downloadBatch(BatchConfig p_314536_, Map<UUID, DownloadRequest> p_314654_) {
        return CompletableFuture.supplyAsync(() -> this.runDownload(p_314536_, p_314654_), this.tasks::tell);
    }

    @Override
    public void close() throws IOException {
        this.tasks.close();
        this.eventLog.close();
    }

    record LogEntry(UUID id, String url, Instant time, Optional<String> hash, Either<String, FileInfoEntry> errorOrFileInfo) {
        public static final Codec<LogEntry> CODEC = RecordCodecBuilder.create(p_314637_ -> p_314637_.group((App)UUIDUtil.STRING_CODEC.fieldOf("id").forGetter(LogEntry::id), (App)Codec.STRING.fieldOf("url").forGetter(LogEntry::url), (App)ExtraCodecs.INSTANT_ISO8601.fieldOf("time").forGetter(LogEntry::time), (App)Codec.STRING.optionalFieldOf("hash").forGetter(LogEntry::hash), (App)Codec.mapEither((MapCodec)Codec.STRING.fieldOf("error"), (MapCodec)FileInfoEntry.CODEC.fieldOf("file")).forGetter(LogEntry::errorOrFileInfo)).apply((Applicative)p_314637_, LogEntry::new));
    }

    public record BatchResult(Map<UUID, Path> downloaded, Set<UUID> failed) {
        public BatchResult() {
            this(new HashMap<UUID, Path>(), new HashSet<UUID>());
        }
    }

    public record BatchConfig(HashFunction hashFunction, int maxSize, Map<String, String> headers, Proxy proxy, HttpUtil.DownloadProgressListener listener) {
    }

    record FileInfoEntry(String name, long size) {
        public static final Codec<FileInfoEntry> CODEC = RecordCodecBuilder.create(p_314458_ -> p_314458_.group((App)Codec.STRING.fieldOf("name").forGetter(FileInfoEntry::name), (App)Codec.LONG.fieldOf("size").forGetter(FileInfoEntry::size)).apply((Applicative)p_314458_, FileInfoEntry::new));
    }

    public record DownloadRequest(URL url, @Nullable HashCode hash) {
    }
}

